﻿//Programed by NAS6
//rngkt.js

//Runge-Kutta method//ルンゲ-クッタ法
//velocity and accel is trans rorenz、/CNST_C kepp value,positon real//速度と加速度はローレンツ変換、/CNST_Cで値保持、座標は実座標
class N6LRngKt {

  constructor() {

    this.typename = "N6LRngKt";
    this.CNST_G = 0.00000000006673;
    this.CNST_C = 299792458.0;
    this.CNST_AU = 149597870700.0;

    this.dms;
    this.n;
    this.mp = new Array();
    this.dt;


    this.blog = false;
    this.bInit = 0;
    this.timeInit = 0;
    this.planet = null;

    this.debugdata = [];


    this.vx = null;
    this.vy = null;
    this.vz = null;
    this.mat = null;
    this.normX = null;
    this.normY = null;
    this.normZ = null; //軌道法線


    this.perith = null;
    this.bperi = false;
    this.bbperi = 0;
    this.bentperi = false;
    this.bextperi = false;
    this.apheth = null;
    this.baphe = false;
    this.bbaphe = 0;
    this.bentaphe = false;
    this.bextaphe = false;
    this.near = 2.5;

    this.rdx = new Array();
    this.dx = new Array();
    this.nrm = new Array();
    this.pow = new Array();
    this.ik = new Array();
    this.im = new Array();
    this.r = new Array();
    this.aa = new Array();
    this.al = new Array();
    this.ap = new Array();
    this.b = new Array();
    this.c = new Array();
    this.d = new Array();
    this.coef = new Array(1.0, 2.0, 2.0, 1.0);

    this.swa = true //force relation distance
    this.swb = true //force proportionality velocity
    this.swc = true //force proportionality square velocity
    this.swd = true //force certain
  }


    //速度加速
    VelocityAccl2D(v, a, dt) {
        if(a.Abs() == 0.0) return v;
        if(1.0 < v.Abs()) {
            if(v.x[1] <= v.x[0]) v.x[1] = Math.sqrt(1.0 - v.x[0] * v.x[0]);
            if(v.x[0] < v.x[1]) v.x[0] = Math.sqrt(1.0 - v.x[1] * v.x[1]);
        }

        var va = v.Abs();
        var aa = a.Abs();

        var vab = Math.tanh(aa * dt);
        var vac = ((va + vab) / (va * vab + 1.0));

        var ret = v.Add(a.Mul(dt));

        if(1.0 < vac) ret = ret / vac;

        return ret
    };

    //速度加速
    VelocityAccl3D(v, a, dt) {
        if(a.Abs() == 0.0) return v;
        if(1.0 < v.Abs()) {
            if(v.x[1] <= v.x[0] && v.x[2] <= v.x[0]) {
                v.x[1] = Math.sqrt((1.0 - v.x[0] * v.x[0]) / 2.0);
                v.x[2] = Math.sqrt((1.0 - v.x[0] * v.x[0]) / 2.0);
            }
            if(v.x[2] <= v.x[1] && v.x[0] < v.x[1]) {
                v.x[2] = Math.sqrt((1.0 - v.x[1] * v.x[1]) / 2.0);
                v.x[0] = Math.sqrt((1.0 - v.x[1] * v.x[1]) / 2.0);
            }
            if(v.x[0] < v.x[2] && v.x[1] < v.x[2]) {
                v.x[0] = Math.sqrt((1.0 - v.x[2] * v.x[2]) / 2.0);
                v.x[1] = Math.sqrt((1.0 - v.x[2] * v.x[2]) / 2.0);
            }
        }

        var va = v.Abs();
        var aa = a.Abs();

        var vab = Math.tanh(aa * dt);
        var vac = ((va + vab) / (va * vab + 1.0));

        var ret = v.Add(a.Mul(dt));

        if(1.0 < vac) ret = ret.Div(vac);
        return ret;
    };

    //速度合成
    //v1をx軸とする座標系に回転して変換しxブースト相対論的速度合成則を適用し元に戻す
    VelocityAdd2D(v0, v1) {
        ret = new N6LVector(v0.x.length);
        var ra = v1.Abs();
        var i;
        if(v0.Abs() == 0.0) {
            if(1.0 < ra) {
                for(i = 0; i < v0.x.length; i++)
                    ret.x[i] = v1.x[i] / ra;
            }
            else ret = v1;
            return ret;
        }
        ra = v0.Abs();
        if(v1.Abs() == 0.0) {
            if(1.0 < ra) {
                for(i = 0; i < v0.x.length; i++)
                    ret.x[i] = v0.x[i] / ra;
            }
            else ret = v0;
            return ret;
        }

        var v = v0.Abs();
        var v11 = new N6LVector(3);
        var v00 = new N6LVector(3);
        for(i = 0; i < v0.x.length; i++) {
            v11.x[i] = v1.x[i];
            v00.x[i] = v0.x[i];
        }
        v11.x[i] = 0.0;
        v00.x[i] = 0.0;
        var ux = ret.UnitVec(0);
        var crs = v00.Cross(ux);

        var theta = v00.Theta(ux);
        if(isNaN(theta)) {
            theta = v11.Theta(ux);
            if(isNaN(theta)) theta = 0.0;
            else v00 = v11.RotAxis(crs, theta);
        }
        else v00 = v00.RotAxis(crs, theta);
        
        v11 = v11.RotAxis(crs, theta);
        if(v11.x[0] * v == -1.0) v11.x[0] = -0.99999999999999989;

        var ret = new N6LVector([
            ((v11.x[0] + v) / (v11.x[0] * v + 1.0)),
            ((v11.x[1]) / (v11.x[0] * v + 1.0)) * Math.sqrt(1.0 - v * v),
            ((v11.x[2]) / (v11.x[0] * v + 1.0)) * Math.sqrt(1.0 - v * v)]);
        ret = ret.RotAxis(crs, -theta);
        ra = ret.Abs();
        if(1.0 < ra) {
            for(i = 0; i < v0.x.length; i++)
                ret.x[i] = ret.x[i] / ra;
        }
        return ret;
    };

    //速度合成
    //v1をx軸とする座標系に回転して変換しxブースト相対論的速度合成則を適用し元に戻す
    VelocityAdd3D(v0, v1) {
        ret = new N6LVector(v0.x.length);
        var ra = v1.Abs();
        var i;
        if(v0.Abs() == 0.0) {
            if(1.0 < ra) {
                for(i = 0; i < v0.x.length; i++)
                    ret.x[i] = v1.x[i] / ra;
            }
            else ret = v1;
            return ret;
        }
        ra = v0.Abs();
        if(v1.Abs() == 0.0) {
            if(1.0 < ra) {
                for(i = 0; i < v0.x.length; i++)
                    ret.x[i] = v0.x[i] / ra;
            }
            else ret = v0;
            return ret;
        }

        var v = v0.Abs();
        var v11 = new N6LVector(3);
        var v00 = new N6LVector(3);
        for(i = 0; i < v0.x.length; i++) {
            v11.x[i] = v1.x[i];
            v00.x[i] = v0.x[i];
        }
        var ux = ret.UnitVec(0);
        var crs = v00.Cross(ux);

        var theta = v00.Theta(ux);
        if(isNaN(theta)) {
            theta = v11.Theta(ux);
            if(isNaN(theta)) theta = 0.0;
            else v00 = v11.RotAxis(crs, theta);
        }
        else v00 = v00.RotAxis(crs, theta);
        
        v11 = v11.RotAxis(crs, theta);
        if(v11.x[0] * v == -1.0) v11.x[0] = -0.99999999999999989;

        var ret = new N6LVector([
            ((v11.x[0] + v) / (v11.x[0] * v + 1.0)),
            ((v11.x[1]) / (v11.x[0] * v + 1.0)) * Math.sqrt(1.0 - v * v),
            ((v11.x[2]) / (v11.x[0] * v + 1.0)) * Math.sqrt(1.0 - v * v)]);
        ret = ret.RotAxis(crs, -theta);
        ra = ret.Abs();
        if(1.0 < ra) {
            for(i = 0; i < v0.x.length; i++)
                ret.x[i] = ret.x[i] / ra;
        }
        return ret;
    };

    //schwartz radius//シュワルツシルト半径
    GetSRadius(mass, cc, cg) {
        return ((2.0 * cg * mass) / (cc * cc));
    };

    //Eccentricity //離心率簡易計算 dv=p1-p2v θ=dv.Theta(v1) θ=0→e=1 : θ=π/4→e=0 therefore e = cosθ
    GetEccentricity(p1, v1, p2){
      var dv = p1.Sub(p2);
      var th = dv.Theta(v1);
      var ret = Math.cos(th);
      if(ret < 0) ret *= -1;
      return ret;
    }

    //schwartz correction term//シュワルツシルト補正項
    ToSchwartz(v, e) {
        var ret = 3.0 * v * v / ( 1.0 - (e * e)); //楕円一般相対論//eは一周の積分するときに必要
        if(0.95 < e) ret = -0.5 * v * v;          //直線特殊相対論
        return ret;
    };

    //NAS6 correction term//NAS6補正項
    ToNAS6() {
        return 1 / 4e60;
    };

    //calc accel//加速度の計算
    GetA(r, m, mr, v, e) {
        if(r == 0.0) return 0.0;
        var a = 1.0;
        if(mr <= r) mr = r;
        else a = r / mr;
        var g = this.CNST_G * (m / mr / mr) * a;
        g = g * (1.0 + this.ToSchwartz(v, e)/* - this.ToNAS6() */);
        if(g < 0.0 || isNaN(g)) return 0.0;
        return g / this.CNST_C;
    };

    //calc accel//質点毎の加速度の計算
    accel() {
        var i;
        var j;
        var k;
        var fw;
        var fw1;
 
        if(this.swa || this.swc) {
            for(i = 0; i < this.n; i++) {
                if(this.swa) {
                    if(this.mp[i].mass <= 0.0) continue;
                    for(j = i + 1; j <= this.n; j++) {
                        if(this.mp[j].mass <= 0.0) continue;
                        fw = 0.0;
                        this.dx[i][j] = this.mp[i].x1.Sub(this.mp[j].x1);
                        for(k = 0; k <= this.dms; k++) fw += this.dx[i][j].x[k] * this.dx[i][j].x[k];
                        this.r[i][j] = Math.sqrt(fw);

                        for(k = 0; k <= this.dms; k++) {
                            if(this.r[i][j] != 0.0) this.nrm[i][j].x[k] = this.dx[i][j].x[k] / this.r[i][j];
                            else this.nrm[i][j].x[0] = 1.0;
                        }
                        this.r[i][j] = this.r[i][j] - this.al[i][j];
                        //this.r[j][i] = this.r[i][j];

                        if(this.ap[i][j] == 0) this.pow[i][j] = 1.0;
                        if(this.ap[i][j] == -2) {
                            if(this.r[i][j] != 0.0) this.pow[i][j] = 1.0 / this.r[i][j] / this.r[i][j];
                            else this.pow[i][j] = 0.0;
                        }

                        if(this.ap[j][i] == 0) this.pow[j][i] = 1.0;
                        if(this.ap[j][i] == -2) {
                            if(this.r[i][j] != 0.0) this.pow[j][i] = 1.0 / this.r[i][j] / this.r[i][j];
                            else this.pow[j][i] = 0.0;
                        }

                        if(this.ap[i][j] == -1) {//relative gravity   //相対性理論万有引力
                            var a1;
                            //velocity orbital component //軌道成分速度
                            var ov = new N6LVector(3);
                            var dx2 = new N6LVector(3);
                            var dx3 = new N6LVector(3);
                            var dx1 = new N6LVector(3);
                            var vv1 = new N6LVector(3);
                            for(k = 0; k < this.dx[i][j].x.length; k++) {
                                dx1.x[k] = this.dx[i][j].x[k];
                                vv1.x[k] = this.mp[i].v1.x[k];
                            }
                            if(dx1.Abs() != 0.0) {
                                if(dx1.isParallel(vv1)) {
                                    if(dx1.isParallel(dx2.UnitVec(0))) dx2 = dx1.Cross(dx2.UnitVec(1));
                                    else dx2 = dx1.Cross(dx2.UnitVec(0));
                                }
                                else dx2 = dx1.Cross(vv1);
                                
                                if(dx1.isParallel(dx2)) dx3 = dx1; //ERROR
                                else dx3 = dx1.Cross(dx2);
                                ov = vv1.ProjectAxis(dx3);
                                if(isNaN(ov.x[0])) ov = ov.ZeroVec();
                            }
                            //this.mp[i].e = this.GetEccentricity(this.mp[i].x1,ov,this.mp[j].x1);
                            //a1 = this.GetA(this.r[i][j], this.mp[j].mass, this.mp[j].r, ov.Abs(), this.mp[i].e);
                            a1 = this.GetA(this.r[i][j], this.mp[j].mass, this.mp[j].r, ov.Abs(), 0.0);
                            this.pow[i][j] = a1;
                        }
                        if(this.ap[j][i] == -1) {//relative gravity   //相対性理論万有引力
                            var a1;
                            //velocity orbital component //軌道成分速度
                            var ov = new N6LVector(3);
                            var dx2 = new N6LVector(3);
                            var dx3 = new N6LVector(3);
                            var dx1 = new N6LVector(3);
                            var vv1 = new N6LVector(3);
                            for(k = 0; k < this.dx[i][j].x.length; k++) {
                                dx1.x[k] = -this.dx[i][j].x[k];
                                vv1.x[k] = this.mp[j].v1.x[k];
                            }
                            if(dx1.Abs() != 0.0) {
                                if(dx1.isParallel(vv1)) {
                                    if(dx1.isParallel(dx2.UnitVec(0))) dx2 = dx1.Cross(dx2.UnitVec(1));
                                    else dx2 = dx1.Cross(dx2.UnitVec(0));
                                }
                                else dx2 = dx1.Cross(vv1);
                                
                                if(dx1.isParallel(dx2)) dx3 = dx1; //ERROR
                                else dx3 = dx1.Cross(dx2);
                                ov = vv1.ProjectAxis(dx3);
                                if(isNaN(ov.x[0])) ov = ov.ZeroVec();
                            }
                            //this.mp[i].e = this.GetEccentricity(this.mp[i].x1,ov,this.mp[j].x1);
                            //a1 = this.GetA(this.r[i][j], this.mp[i].mass, this.mp[i].r, ov.Abs(), this.mp[i].e);
                            a1 = this.GetA(this.r[i][j], this.mp[i].mass, this.mp[i].r, ov.Abs(), 0.0);
                            this.pow[j][i] = a1;
                        }

                        if(this.ap[i][j] == 1) this.pow[i][j] = this.r[i][j];
                        if(this.ap[j][i] == 1) this.pow[j][i] = this.r[i][j];

                        this.pow[i][j] = this.pow[i][j] * this.aa[i][j];
                        this.pow[j][i] = this.pow[j][i] * this.aa[j][i];
                    }
                }

                fw1 = 0.0;
                for(k = 0; k <= this.dms; k++) fw1 += this.mp[i].v1.x[k] * this.mp[i].v1.x[k];
                this.mp[i].va = Math.sqrt(fw1);
                for(k = 0; k <= this.dms; k++) {
                    if(this.mp[i].va != 0.0) this.mp[i].vn.x[k] = this.mp[i].v1.x[k] / this.mp[i].va;
                }
            }
        }

        for(i = 0; i <= this.n; i++)
            for(k = 0; k <= this.dms; k++)
                this.mp[i].a.x[k] = 0.0; //clear

        for(i = 0; i <= this.n; i++) {
            if(this.swa) { //2 object interaction //２物体間の相互作用
                if(i != this.n) {
                    for(j = i + 1; j <= this.n; j++) {
                        var a = new N6LVector(this.dms + 1);
                        for(k = 0; k <= this.dms; k++) {
                            a.x[k] = ((this.nrm[i][j].x[k] * this.pow[i][j] / (this.mp[i].mass)));
                            this.mp[i].a.x[k] = this.mp[i].a.x[k] + a.x[k];

                            a.x[k] = ((-this.nrm[i][j].x[k] * this.pow[j][i] / (this.mp[j].mass)));
                            this.mp[j].a.x[k] = this.mp[j].a.x[k] + a.x[k];
                        }
                    }
                }
            }
            if(this.swb) { //force proportionality velocity//速さに比例する力（粘性抵抗）
                var a = new N6LVector(this.dms + 1);
                for(k = 0; k <= this.dms; k++) {
                    a.x[k] = ((this.mp[i].v1.x[k] * this.b[i]) / (this.mp[i].mass));
                    this.mp[i].a.x[k] = this.mp[i].a.x[k] + a.x[k];
                }
            }
            if(this.swc) { //force proportionality square velocity//速さの二乗に比例する抵抗（慣性抵抗）
                var a = new N6LVector(this.dms + 1);
                for(k = 0; k <= this.dms; k++) {
                    a.x[k] = ((this.mp[i].vn.x[k] * this.mp[i].va * this.mp[i].va * this.c[i]) / (this.mp[i].mass));
                    this.mp[i].a.x[k] = this.mp[i].a.x[k] + a.x[k];
                }
            }
            if(this.swd) { //force certain//一定の力（重力など）
                var a = new N6LVector(this.dms + 1);
                for(k = 0; k <= this.dms; k++) {
                    a.x[k] = ((this.d[i].x[k]) / (this.mp[i].mass));
                    this.mp[i].a.x[k] = this.mp[i].a.x[k] + a.x[k];
                }
            }
        }
    };

    //Runge-Kutta method//ルンゲ-クッタ法
    UpdateFrame() {
        var i;
        var k;
        var l;

        //init//設定
        for(i = 0; i <= this.n; i++) {
            for(k = 0; k <= this.dms; k++) {
                this.mp[i].x1.x[k] = this.mp[i].x.x[k];
                this.mp[i].x0.x[k] = this.mp[i].x.x[k];
                this.mp[i].v1.x[k] = this.mp[i].v.x[k];
                this.mp[i].w.x[k] = 0.0;
                this.mp[i].w1.x[k] = 0.0;
            }
        }

        //Runge-Kutta method//ルンゲ-クッタ法
        this.accel();//質点毎に加速度を計算
        //質点毎に速度をルンゲ-クッタ法で計算
        for(l = 0; l <= 2; l++) {
            for(i = 0; i <= this.n; i++) {
                if(this.mp[i].mass <= 0.0) continue;
                var v01 = new N6LVector(this.dms + 1);
                var v02 = new N6LVector(this.dms + 1);
                var v1 = new N6LVector(this.dms + 1);
                var v2 = new N6LVector(this.dms + 1);
                this.ik[l][i] = this.mp[i].v1.Mul(this.dt * this.CNST_C);
                this.mp[i].x1 = this.mp[i].x.Add(this.ik[l][i].Div(this.coef[l + 1]));
                this.mp[i].x0 = new N6LVector(this.mp[i].x1);
                this.mp[i].w = this.mp[i].w.Add(this.ik[l][i].Mul(this.coef[l]));

                var av = new N6LVector(0);
                if(this.dms == 2) av = this.VelocityAccl3D(new N6LVector(3), this.mp[i].a, this.dt);
                else if(this.dms == 1) av = this.VelocityAccl2D(new N6LVector(2), this.mp[i].a, this.dt);
                
                for(k = 0; k <= this.dms; k++) this.im[l][i].x[k] = av.x[k];

                v1 = this.im[l][i].Div(this.coef[l + 1]);
                v2 = this.im[l][i].Mul(this.coef[l]);
                for(k = 0; k <= this.dms; k++) {
                    this.mp[i].v1.x[k] = (this.mp[i].v.x[k] + v1.x[k]);
                    this.mp[i].w1.x[k] = (this.mp[i].w1.x[k] + v2.x[k]);
                }
            }
            this.accel();//質点毎に加速度を計算
        }
        //質点毎に速度をルンゲ-クッタ法で計算
        for(i = 0; i <= this.n; i++) {
            if(this.mp[i].mass < 0.0) continue;
            var v01 = new N6LVector(this.dms + 1);
            var v02 = new N6LVector(this.dms + 1);
            var v1 = new N6LVector(this.dms + 1);
            var v2 = new N6LVector(this.dms + 1);
            this.ik[l][i] = this.mp[i].v1.Mul(this.dt * this.CNST_C);
            this.mp[i].x1 = this.mp[i].x.Add((this.mp[i].w.Add(this.ik[l][i])).Div(6.0));
            //this.mp[i].x1 = this.mp[i].x.Add((this.mp[i].w.Add(this.ik[l][i])));

            var av = new N6LVector(0);
            if(this.dms == 2) av = this.VelocityAccl3D(new N6LVector(3), this.mp[i].a, this.dt);
            else if(this.dms == 1) av = this.VelocityAccl2D(new N6LVector(2), this.mp[i].a, this.dt);
                
            for(k = 0; k <= this.dms; k++) this.im[l][i].x[k] = av.x[k];

            v1 = new N6LVector(this.im[l][i]);
            for(k = 0; k <= this.dms; k++) {
                v01.x[k] = this.mp[i].w1.x[k];
                v02.x[k] = this.mp[i].v.x[k];
            }
            if(this.dms == 2) {
                for(k = 0; k <= this.dms; k++) v2.x[k] = (v01.x[k] + v1.x[k]) / 6.0;
                //for(k = 0; k <= this.dms; k++) v2.x[k] = (v01.x[k] + v1.x[k]);
                this.mp[i].v1 = this.VelocityAdd3D(v02, v2);
            }
            else if(this.dms == 1) {
                for(k = 0; k <= this.dms; k++) v2.x[k] = (v01.x[k] + v1.x[k]) / 6.0;
                //for(k = 0; k <= this.dms; k++) v2.x[k] = (v01.x[k] + v1.x[k]);
                this.mp[i].v1 = this.VelocityAdd2D(v02, v2);
            }
        }

        var lastx = new N6LVector(3, false);
        var posx = new N6LVector(3, false);
        //applly//パラメータ適用
        for(i = 0; i <= this.n; i++) {
            for(k = 0; k <= this.dms; k++) {
// 1. 太陽からの相対ベクトル（AU単位）
//var r_rel_au = this.mp[1].x.Sub(this.mp[0].x).Div(this.CNST_AU);

//lastx.x[k] = (this.mp[i].x.x[k] - this.mp[0].x.x[k]) / this.CNST_AU;
//posx.x[k] = (this.mp[i].x.x[k] - this.mp[0].x.x[k]) / this.CNST_AU;

//lastx.x[k] = this.mp[i].x.Sub(this.mp[0].x).Div(this.CNST_AU);
lastx.x[k] = this.mp[1].x.Sub(this.mp[0].x).Div(this.CNST_AU);

                this.mp[i].x.x[k] = this.mp[i].x1.x[k];
                this.mp[i].v.x[k] = this.mp[i].v1.x[k];


//posx = this.mp[i].x.Sub(this.mp[0].x).Div(this.CNST_AU);
posx = this.mp[1].x.Sub(this.mp[0].x).Div(this.CNST_AU);
            }
            if(i === this.mp[i].centerID) continue;
            if(this.blog === false) continue;
            var lr = this.mp[i].lastR;
            var nr = this.r[this.mp[i].centerID][i];
            var id = nr - lr;

            this.OnDispLog(i, posx); // 天体番号、座標を通知


            // 減少から増加に転じた瞬間 (近日点)
            if((0 < id)&&(this.mp[i].isDecreasing < 0)){
                if(typeof this.onPerihelion === 'function') {
                  this.onPerihelion(i, lr, posx); // 天体番号、距離、座標を通知


if((1 < this.bInit)&&((this.perith === null)||(this.bbperi == 1))){
this.bbperi++;

var r_rel_au = new N6LVector(posx);

// 3. 物理的なAU座標を投影！
var c0 = r_rel_au.Dot(this.normX); // X座標 (AU)
var c1 = r_rel_au.Dot(this.normY); // Y座標 (AU)
var c2 = this.normZ.Dot(r_rel_au);  // Z座標 (AU) → ここがほぼ0になるはず！

// 1. 水星の遠日点距離 (約 0.4667 AU)
//var aphelion = 0.4667; 
var aphelion = this.planet[1].m_rb; 

// 2. 現在の座標をその距離で割る
var c00 = c0 / aphelion; // これで最大 +1, 最小 -1 付近になる
var c11 = c1 / aphelion;
this.perith = Math.atan2(c11,c00);//とりあえずの近日点角度

}
                  if(!this.bperi){
                    this.bperi = true; this.bentperi = false; this.bextperi = true;
                  }

                }
            }
            // 増加から減少に転じた瞬間 (遠日点)
            if((id < 0)&&(0 < this.mp[i].isDecreasing)){
                if(this.bInit === 0){
                     this.bInit++;
                     this.timeInit = this.time;

this.debugdata.push(new N6LVector(posx));

/*
var ss = this.planet[i].m_s * this.planet[i].CNST_DR;
var ii = this.planet[i].m_i * this.planet[i].CNST_DR;
var ww = this.planet[i].m_w * this.planet[i].CNST_DR;

//rotate matrix//行列回転//ss,ii,ww,+-???
var vec = new N6LVector(3);
this.mat = new N6LMatrix(3);
this.mat = this.mat.UnitMat().RotAxis(vec.UnitVec(2), ss).RotAxis(vec.UnitVec(0), ii).RotAxis(vec.UnitVec(2), ww).NormalMat();
*/
/*
this.mat.x[0].x[1] = -this.planet[i].m_earth.x0.x[0] * this.planet[i].CNST_DR;
this.mat.x[0].x[2] = -this.planet[i].m_earth.x0.x[1] * this.planet[i].CNST_DR;
this.mat.x[0].x[3] = -this.planet[i].m_earth.x0.x[2] * this.planet[i].CNST_DR;
*/
/*
var dt = [];
this.mat = this.mat.InverseMat(dt).NormalMat();

this.vx  = new N6LVector(this.mat.x[0]);
this.vy  = new N6LVector(this.mat.x[1]);
this.vz  = new N6LVector(this.mat.x[2]);
*/
/*
vec = new N6LVector([1,0,0]);
vec = this.mat.Mul(vec).NormalVec();
ss=ss;
*/
                }
                if(typeof this.onAphelion === 'function') {


                  this.onAphelion(i, lr, posx); // 天体番号、距離、座標を通知

if((1 < this.bInit)&&((this.apheth === null)||(this.bbaphe == 1))){
this.bbaphe++;

var r_rel_au = new N6LVector(posx);

// 3. 物理的なAU座標を投影！
var c0 = r_rel_au.Dot(this.normX); // X座標 (AU)
var c1 = r_rel_au.Dot(this.normY); // Y座標 (AU)
var c2 = this.normZ.Dot(r_rel_au);  // Z座標 (AU) → ここがほぼ0になるはず！

// 1. 水星の遠日点距離 (約 0.4667 AU)
//var aphelion = 0.4667; 
var aphelion = this.planet[1].m_rb; 

// 2. 現在の座標をその距離で割る
var c00 = c0 / aphelion; // これで最大 +1, 最小 -1 付近になる
var c11 = c1 / aphelion;
this.apheth = Math.atan2(c11,c00);//とりあえずの近日点角度

}
                  if(!this.baphe){
                    this.baphe = true; this.bentaphe = false; this.bextaphe = true;
                  }
                }
            }
            if(this.bInit === 1){
                if((this.timeInit)&&(this.planet)){
                     if(this.timeInit + (this.planet[i].m_t * 1000 * 3600 * 24 * 365.2425) / 4 <= this.time){
                         this.bInit++;


this.debugdata.push(new N6LVector(posx));
this.vz = this.debugdata[0].Cross(this.debugdata[1]).NormalVec();
this.vx = this.debugdata[1].Cross(vz).NormalVec();
this.vy = this.debugdata[1].Cross(vx).NormalVec();

this.normZ = new N6LVector(this.vz).NormalVec(); //軌道法線
this.normX = new N6LVector(this.vx).NormalVec(); // 遠日点方向など
this.normY = this.normZ.Cross(this.normX).NormalVec();


                         this.onSide(i, lr, posx); // 天体番号、距離、座標を通知

                     }
                }
            }
if(this.vx !== null){



/*

// 1. 太陽からの相対ベクトル（AU単位）
var r_rel_au = this.mp[1].x.Sub(this.mp[0].x).Div(this.CNST_AU);

// 2. 投影軸（これらは方向だけなので NormalVec でOK）
// vz, vx, vy は以前作った「軌道面の法線ベクトル」などを使います
var n = new N6LVector(this.vz).NormalVec(); 
var m0 = new N6LVector(this.vx).NormalVec(); // 遠日点方向など
var m1 = n.Cross(m0).NormalVec();

// 3. 物理的なAU座標を投影！
var c0 = r_rel_au.Dot(m0); // X座標 (AU)
var c1 = r_rel_au.Dot(m1); // Y座標 (AU)
var c2 = n.Dot(r_rel_au);  // Z座標 (AU) → ここがほぼ0になるはず！

// 1. 水星の遠日点距離 (約 0.4667 AU)
var aphelion = 0.4667; 

// 2. 現在の座標をその距離で割る
var c00 = c0 / aphelion; // これで最大 +1, 最小 -1 付近になる
var c11 = c1 / aphelion;



document.F2.T1.value = c00;
document.F2.T2.value = c11;
document.F2.T3.value = c2;
document.F2.T4.value = c00*c00+c11*c11+c2*c2;//1
document.F2.T5.value = Math.atan2(c11,c00);
*/



var r_rel_au = new N6LVector(posx);

// 3. 物理的なAU座標を投影！
var c0 = r_rel_au.Dot(this.normX); // X座標 (AU)
var c1 = r_rel_au.Dot(this.normY); // Y座標 (AU)
var c2 = this.normZ.Dot(r_rel_au);  // Z座標 (AU) → ここがほぼ0になるはず！

// 1. 水星の遠日点距離 (約 0.4667 AU)
//var aphelion = 0.4667; 
var aphelion = this.planet[1].m_rb; 

// 2. 現在の座標をその距離で割る
var c00 = c0 / aphelion; // これで最大 +1, 最小 -1 付近になる
var c11 = c1 / aphelion;
var theta = Math.atan2(c11,c00);//とりあえずの角度
/*
document.FD.T1.value = r_rel_au.x[0];
document.FD.T2.value = r_rel_au.x[1];
document.FD.T3.value = r_rel_au.x[2];
*/

document.FD.T1.value = theta;
document.FD.T2.value = c0;
document.FD.T3.value = c1;
document.FD.T4.value = c2;






/*
//posx.x[k] = this.mp[i].x1.x[k] - this.mp[0].x.x[k];//mp[i]評価する星mp[0]太陽
//var r = this.mat.Mul(posx).NormalVec();//可変パラメタ
var r = posx.NormalVec();//可変パラメタ
var n = new N6LVector(this.vz).NormalVec();
var rabs = r.Abs();//1
var d = r.Dot(n);//e-17
var m0 = this.debugdata[0].Cross(n).NormalVec();
var c0 = m0.Dot(r);
//var s0 = m0.Cross(r).Dot(n);
//var s0 = Math,sqrt(1 - c0 * c0);
//var th0 = Math.atan2(s0,c0);
//document.F2.T1.value = th0;
var m1 = n.Cross(m0).NormalVec();
var c1 = m1.Dot(r);
//var s1 = m1.Cross(n).Dot(r);
//var s1 = Math,sqrt(1 - c1 * c1);
//var th1 = Math.atan2(s1,c1);
//document.F2.T2.value = th1;
var m2 = m0.Cross(m1).NormalVec();
var c2 = m2.Dot(r);
//var s2 = m2.Cross(n).Dot(r);
//var s2 = Math,sqrt(1 - c2 * c2);
//var th2 = Math.atan2(s2,c2);
//document.F2.T3.value = th2;

//var rfull = new N6LVector(posx).Sub(this.mp[0].x);
//var c0A = rfull.Dot(m0);
//var c1A = rfull.Dot(m1);

//c0c1が13-14で収束7の倍数というとカメラのｚ距離が7でしたね
document.F2.T1.value = c0 / 0.05;        //-0.8483510121179634
document.F2.T2.value = c1 / 0.05;        //-0.5357326496820776
document.F2.T3.value = c2;//0.2782281711419286
document.F2.T4.value = c0*c0+c1*c1+c2*c2;//1
*/
/*
// 1. まず「太陽中心の物理距離ベクトル」を、正規化せずそのまま作る
var r_phys = posx.Sub(this.mp[0].x); 

// 2. 投影に使う「軸(m0, m1, n)」だけは NormalVec で方向のみにする
var n = new N6LVector(this.vz).NormalVec();
var m0 = this.debugdata[0].Cross(n).NormalVec();
var m1 = n.Cross(m0).NormalVec();

// 3. 物理距離を、方向ベクトル(軸)に投影する
var c0 = m0.Dot(r_phys); // これで「メートル単位」のXが出る
var c1 = m1.Dot(r_phys); // これで「メートル単位」のYが出る
var c2 = n.Dot(r_phys);  // これが「0」に張り付くか確認

// 4. 値が大きすぎるなら、定数（天文単位など）で割って表示する
document.F2.T1.value = c0 / this.CNST_AU; // AU単位で表示
document.F2.T2.value = c1 / this.CNST_AU;
document.F2.T3.value = c2 / this.CNST_AU;
document.F2.T4.value = c0*c0+c1*c1+c2*c2;//1
*/
/*

// 1. 太陽からの相対ベクトル（AU単位）
var r_rel_au = this.mp[1].x.Sub(this.mp[0].x).Div(this.CNST_AU);

// 2. 投影軸（これらは方向だけなので NormalVec でOK）
// vz, vx, vy は以前作った「軌道面の法線ベクトル」などを使います
var n = new N6LVector(this.vz).NormalVec(); 
var m0 = new N6LVector(this.vx).NormalVec(); // 遠日点方向など
var m1 = n.Cross(m0).NormalVec();

// 3. 物理的なAU座標を投影！
var c0 = r_rel_au.Dot(m0); // X座標 (AU)
var c1 = r_rel_au.Dot(m1); // Y座標 (AU)
var c2 = n.Dot(r_rel_au);  // Z座標 (AU) → ここがほぼ0になるはず！

// 1. 水星の遠日点距離 (約 0.4667 AU)
var aphelion = 0.4667; 

// 2. 現在の座標をその距離で割る
var c00 = c0 / aphelion; // これで最大 +1, 最小 -1 付近になる
var c11 = c1 / aphelion;



document.F2.T1.value = c00;
document.F2.T2.value = c11;
document.F2.T3.value = c2;
document.F2.T4.value = c00*c00+c11*c11+c2*c2;//1
document.F2.T5.value = Math.atan2(c11,c00);

*/

/*

var rrrrrrr = this.mp[1].x.Sub(this.mp[0].x);

document.F2.T1.value = rrrrrrr.Div(this.CNST_AU).Str();


*/


/*
//r自体は原点O周りなのになぜc0c1c2が限定振動？


//c0,c1,c2?
//でrのデバッグをしていますがcが限定振動であることはrに何かのオフセットがあるみたいです


*/



/*
var th0 = this.mp[i].x.Theta(this.vx);
var th1 = this.mp[i].x.Theta(this.vy);
var th2 = this.mp[i].x.Theta(this.vz);


document.F2.T1.value = th0;
document.F2.T2.value = th1;
document.F2.T3.value = th2;
*/
}

            this.mp[i].lastR = nr;
            this.mp[i].isDecreasing = id;

            //近日点突入脱出通知
            if((this.bperi)&&(this.perith !==null)){
if(this.bbperi == 0) this.bbperi++;
if(this.bbaphe == 0) this.bbaphe++;

var r_rel_au = new N6LVector(posx);

// 3. 物理的なAU座標を投影！
var c0 = r_rel_au.Dot(this.normX); // X座標 (AU)
var c1 = r_rel_au.Dot(this.normY); // Y座標 (AU)
var c2 = this.normZ.Dot(r_rel_au);  // Z座標 (AU) → ここがほぼ0になるはず！

// 1. 水星の遠日点距離 (約 0.4667 AU)
//var aphelion = 0.4667; 
var aphelion = this.planet[1].m_rb; 

// 2. 現在の座標をその距離で割る
var c00 = c0 / aphelion; // これで最大 +1, 最小 -1 付近になる
var c11 = c1 / aphelion;

                var theta = Math.atan2(c11,c00);//とりあえずの近日点角度
                var sub = theta - this.perith;
                  sub = this.NormalizeRad(sub);
                var subent = theta - (this.perith - this.near * (Math.PI / 180));
                  subent = this.NormalizeRad(subent);
                var subext = theta - (this.perith + this.near * (Math.PI / 180));
                  subext = this.NormalizeRad(subext);
                if((this.bentperi)&&(0 < subent)&&(subext < 0)){
                  this.bentperi = false; this.bextperi = true;
                  this.OnEnterPerihelion(i);
                }
                if((this.bextperi)&&(0 < subext)){
                  this.bextperi = false; this.bentperi = true;
                  this.OnExitPerihelion(i);
                }

                theta = Math.atan2(c11,c00);//とりあえずの近日点角度
                sub = theta - this.apheth;
                sub = this.NormalizeRad(sub);
                subent = theta - (this.apheth - this.near * (Math.PI / 180));
                subent = this.NormalizeRad(subent);
                subext = theta - (this.apheth + this.near * (Math.PI / 180));
                subext = this.NormalizeRad(subext);
                if((this.bentaphe)&&(0 < subent)&&(subext < 0)){
                  this.bentaphe = false; this.bextaphe = true;
                  this.OnEnterAphelion(i);
                }
                if((this.bextaphe)&&(0 < subext)){
                  this.bextaphe = false; this.bentaphe = true;
                  this.OnExitAphelion(i);
                }

            }
        }
        this.time = this.time + this.dt * 1000;
    };

    //calc accel2:this.mp[0]とだけ重力相互作用の計算//質点毎の加速度の計算
    accel2() {
        var i;
        var j;
        var k;
        var fw;
        var fw1;
 
        if(this.swa || this.swc) {
            i = 0;
                if(this.swa) {
                    for(j = i + 1; j <= this.n; j++) {
                        if(this.mp[j].mass <= 0.0) continue;
                        fw = 0.0;
                        this.dx[i][j] = this.mp[i].x1.Sub(this.mp[j].x1);
                        for(k = 0; k <= this.dms; k++) fw += this.dx[i][j].x[k] * this.dx[i][j].x[k];
                        this.r[i][j] = Math.sqrt(fw);

                        for(k = 0; k <= this.dms; k++) {
                            if(this.r[i][j] != 0.0) this.nrm[i][j].x[k] = this.dx[i][j].x[k] / this.r[i][j];
                            else this.nrm[i][j].x[0] = 1.0;
                        }
                        this.r[i][j] = this.r[i][j] - this.al[i][j];

                        if(this.ap[i][j] == 0) this.pow[i][j] = 1.0;
                        if(this.ap[j][i] == 0) this.pow[j][i] = 1.0;
                        if(this.ap[j][i] == -2) {
                            if(this.r[i][j] != 0.0) this.pow[j][i] = 1.0 / this.r[i][j] / this.r[i][j];
                            else this.pow[j][i] = 0.0;
                        }
                        if(this.ap[j][i] == -1) {//relative gravity   //相対性理論万有引力
                            var a1;
                            //velocity orbital component //軌道成分速度
                            var ov = new N6LVector(3);
                            var dx2 = new N6LVector(3);
                            var dx3 = new N6LVector(3);
                            var dx1 = new N6LVector(3);
                            var vv1 = new N6LVector(3);
                            for(k = 0; k < this.dx[i][j].x.length; k++) {
                                dx1.x[k] = -this.dx[i][j].x[k];
                                vv1.x[k] = this.mp[j].v1.x[k];
                            }
                            if(dx1.Abs() != 0.0) {
                                if(dx1.isParallel(vv1)) {
                                    if(dx1.isParallel(dx2.UnitVec(0))) dx2 = dx1.Cross(dx2.UnitVec(1));
                                    else dx2 = dx1.Cross(dx2.UnitVec(0));
                                }
                                else dx2 = dx1.Cross(vv1);
                                
                                if(dx1.isParallel(dx2)) dx3 = dx1; //ERROR
                                else dx3 = dx1.Cross(dx2);
                                ov = vv1.ProjectAxis(dx3);
                                if(isNaN(ov.x[0])) ov = ov.ZeroVec();
                            }
                            //this.mp[i].e = this.GetEccentricity(this.mp[i].x1,ov,this.mp[j].x1);
                            //a1 = this.GetA(this.r[i][j], this.mp[i].mass, this.mp[i].r, ov.Abs(), this.mp[i].e);
                            a1 = this.GetA(this.r[i][j], this.mp[i].mass, this.mp[i].r, ov.Abs(), 0.0);
                            this.pow[j][i] = a1;
                        }

//                        if(this.ap[i][j] == 1) this.pow[i][j] = this.r[i][j];
                        if(this.ap[j][i] == 1) this.pow[j][i] = this.r[i][j];

//                        this.pow[i][j] = this.pow[i][j] * this.aa[i][j];
                        this.pow[j][i] = this.pow[j][i] * this.aa[j][i];
                    }
                }

                fw1 = 0.0;
                for(k = 0; k <= this.dms; k++) fw1 += this.mp[i].v1.x[k] * this.mp[i].v1.x[k];
                this.mp[i].va = Math.sqrt(fw1);
                for(k = 0; k <= this.dms; k++) {
                    if(this.mp[i].va != 0.0) this.mp[i].vn.x[k] = this.mp[i].v1.x[k] / this.mp[i].va;
                }
        }


        for(i = 0; i <= this.n; i++)
            for(k = 0; k <= this.dms; k++)
                this.mp[i].a.x[k] = 0.0; //clear

        i = 0;
            if(this.swa) { //2 object interaction //２物体間の相互作用
                if(i != this.n) {
                    for(j = i + 1; j <= this.n; j++) {
                        var a = new N6LVector(this.dms + 1);
                        for(k = 0; k <= this.dms; k++) {
                            a.x[k] = ((this.nrm[i][j].x[k] * this.pow[i][j] / (this.mp[i].mass)));
                            this.mp[i].a.x[k] = this.mp[i].a.x[k] + a.x[k];

                            a.x[k] = ((-this.nrm[i][j].x[k] * this.pow[j][i] / (this.mp[j].mass)));
                            this.mp[j].a.x[k] = this.mp[j].a.x[k] + a.x[k];
                        }
                    }
                }
            }
    };

    //Runge-Kutta method//ルンゲ-クッタ法:this.mp[0]とだけ重力相互作用の計算
    UpdateFrame2() {
        var i;
        var k;
        var l;

        //init//設定
        for(i = 0; i <= this.n; i++) {
            for(k = 0; k <= this.dms; k++) {
                this.mp[i].x1.x[k] = this.mp[i].x.x[k];
                this.mp[i].x0.x[k] = this.mp[i].x.x[k];
                this.mp[i].v1.x[k] = this.mp[i].v.x[k];
                this.mp[i].w.x[k] = 0.0;
                this.mp[i].w1.x[k] = 0.0;
            }
        }


        //Runge-Kutta method//ルンゲ-クッタ法
        this.accel2();//質点毎に加速度を計算
        //質点毎に速度をルンゲ-クッタ法で計算
        for(l = 0; l <= 2; l++) {
            for(i = 0; i <= this.n; i++) {
                if(this.mp[i].mass <= 0.0) continue;
                var v01 = new N6LVector(this.dms + 1);
                var v02 = new N6LVector(this.dms + 1);
                var v1 = new N6LVector(this.dms + 1);
                var v2 = new N6LVector(this.dms + 1);
                this.ik[l][i] = this.mp[i].v1.Mul(this.dt * this.CNST_C);
                this.mp[i].x1 = this.mp[i].x.Add(this.ik[l][i].Div(this.coef[l + 1]));
                this.mp[i].x0 = new N6LVector(this.mp[i].x1);
                this.mp[i].w = this.mp[i].w.Add(this.ik[l][i].Mul(this.coef[l]));

                var av = new N6LVector(0);
                if(this.dms == 2) av = this.VelocityAccl3D(new N6LVector(3), this.mp[i].a, this.dt);
                else if(this.dms == 1) av = this.VelocityAccl2D(new N6LVector(2), this.mp[i].a, this.dt);
                
                for(k = 0; k <= this.dms; k++) this.im[l][i].x[k] = av.x[k];

                v1 = this.im[l][i].Div(this.coef[l + 1]);
                v2 = this.im[l][i].Mul(this.coef[l]);
                for(k = 0; k <= this.dms; k++) {
                    this.mp[i].v1.x[k] = (this.mp[i].v.x[k] + v1.x[k]);
                    this.mp[i].w1.x[k] = (this.mp[i].w1.x[k] + v2.x[k]);
                }
            }
            this.accel2();//質点毎に加速度を計算
        }
        //質点毎に速度をルンゲ-クッタ法で計算
        for(i = 0; i <= this.n; i++) {
            if(this.mp[i].mass < 0.0) continue;
            var v01 = new N6LVector(this.dms + 1);
            var v02 = new N6LVector(this.dms + 1);
            var v1 = new N6LVector(this.dms + 1);
            var v2 = new N6LVector(this.dms + 1);
            this.ik[l][i] = this.mp[i].v1.Mul(this.dt * this.CNST_C);
            this.mp[i].x1 = this.mp[i].x.Add((this.mp[i].w.Add(this.ik[l][i])).Div(6.0));

            var av = new N6LVector(0);
            if(this.dms == 2) av = this.VelocityAccl3D(new N6LVector(3), this.mp[i].a, this.dt);
            else if(this.dms == 1) av = this.VelocityAccl2D(new N6LVector(2), this.mp[i].a, this.dt);
                
            for(k = 0; k <= this.dms; k++) this.im[l][i].x[k] = av.x[k];

            v1 = new N6LVector(this.im[l][i]);
            for(k = 0; k <= this.dms; k++) {
                v01.x[k] = this.mp[i].w1.x[k];
                v02.x[k] = this.mp[i].v.x[k];
            }
            if(this.dms == 2) {
                for(k = 0; k <= this.dms; k++) v2.x[k] = (v01.x[k] + v1.x[k]) / 6.0;
                this.mp[i].v1 = this.VelocityAdd3D(v02, v2);
            }
            else if(this.dms == 1) {
                for(k = 0; k <= this.dms; k++) v2.x[k] = (v01.x[k] + v1.x[k]) / 6.0;
                this.mp[i].v1 = this.VelocityAdd2D(v02, v2);
            }
        }

        //applly//パラメータ適用
        for(i = 0; i <= this.n; i++) {
            for(k = 0; k <= this.dms; k++) {
                this.mp[i].x.x[k] = this.mp[i].x1.x[k];
                this.mp[i].v.x[k] = this.mp[i].v1.x[k];
            }
            if(i === this.mp[i].centerID) continue;
            if(this.blog === false) continue;
            var lr = this.mp[i].lastR;
            var nr = this.r[this.mp[i].centerID][i];
            var id = nr - lr;
            // 減少から増加に転じた瞬間 (近日点)
            if((0 < id)&&(this.mp[i].isDecreasing < 0)){
                if(typeof this.onPerihelion === 'function') {
                  this.onPerihelion(i, lr, this.mp[i].x); // 天体番号、距離、座標を通知
                }
            }
            // 増加から減少に転じた瞬間 (遠日点)
            if((id < 0)&&(0 < this.mp[i].isDecreasing)){
                if(typeof this.onAphelion === 'function') {
                  this.onAphelion(i, lr, this.mp[i].x); // 天体番号、距離、座標を通知
                }
            }
            this.mp[i].lastR = lr;
            this.mp[i].isDecreasing = id;

            //近日点突入脱出通知
            if(this.bperi){
/*
                var quatWK = pos.Matrix().Quaternion();
                var theta = [];
                var axis = [];
                quatWK = quatWK.Axis(axis, theta);
                var sub = theta - this.perith;
                var subent = theta[0] - (this.perith - this.near * (Math.PI / 180));
                var subext = theta[0] - (this.perith + this.near * (Math.PI / 180));
                if((this.perith < Math.PI - this.near * (Math.PI / 180) )||(Math.PI + this.near * (Math.PI / 180) < this.perith)){
                  this.NormalizeRad(subent);
                  this.NormalizeRad(subext);
                }
                if((this.bent)&&(subent < 0)){
                  this.bent = false; this.bext = true;
                  this.OnEnterPerihelion(i);
                }
                if((this.bext)&&(0 <= subext)){
                  this.bext = false; this.bent = true;
                  this.OnExitPerihelion(i);
                }
*/ 
            }
        }
        this.time = this.time + this.dt * 1000;

    };

    //init//ルンゲ-クッタ法初期設定
    Init(pmp, pdt, planet = null, epc = null, blog = false, cc = null, cg = null) {
        var i;
        var j;
        var k = pmp[0].x.x.length;

        this.dms = pmp[0].x.x.length - 1;
        this.n = pmp.length - 1;

        for(i = 0; i <= this.n; i++) {
            this.mp[i] = new N6LMassPoint(pmp[i]);
            this.mp[i].x = new N6LVector(pmp[i].x);
            this.mp[i].v = new N6LVector(pmp[i].v);
            this.mp[i].e = pmp[i].e;
        }
        this.dt = pdt;

        if(cc) this.CNST_C = cc;
        if(cg) this.CNST_G = cg;

        this.blog = blog;

        this.planet = planet;
        this.epoch = epc;

        this.perith = null;
        this.bperi = false;
        this.bbperi = 0;
        this.bentperi = false;
        this.bextperi = false;
        this.apheth = null;
        this.baphe = false;
        this.bbaphe = 0;
        this.bentaphe = false;
        this.bextaphe = false;



        this.time = 0;
        this.rdx = new Array();
        this.dx = new Array();
        this.nrm = new Array();
        this.pow = new Array();
        this.r = new Array();
        this.aa = new Array();
        this.al = new Array();
        this.ap = new Array();
        this.b = new Array();
        this.c = new Array();
        this.d = new Array();
        for(i = 0; i <= this.n; i++) {
            this.rdx[i] = new Array();
            this.dx[i] = new Array();
            this.nrm[i] = new Array();
            this.pow[i] = new Array();
            this.r[i] = new Array();
            this.aa[i] = new Array();
            this.al[i] = new Array();
            this.ap[i] = new Array();
            for(j = 0; j <= this.n; j++) {          
                this.dx[i][j] = new N6LVector(k);
                this.nrm[i][j] = new N6LVector(k);
            }
        }
        for(i = 0; i <= this.n; i++) {
            for(j = i; j <= this.n; j++) {
                this.pow[i][j] = 0.0;
                this.r[i][j] = 0.0;

                this.aa[i][j] = -(this.mp[i].mass);
                this.al[i][j] = 0.0;
                this.ap[i][j] = -1;   //relative gravity   //相対性理論万有引力

                this.pow[j][i] = 0.0;
                this.r[j][i] = 0.0;

                this.aa[j][i] = -(this.mp[j].mass);
                this.al[j][i] = 0.0;
                this.ap[j][i] = -1;   //relative gravity   //相対性理論万有引力
            }
        }
        for(i = 0; i <= 3; i++) {
            this.ik[i] = new Array();
            this.im[i] = new Array();
            for(j = 0; j <= this.n; j++) {
                this.ik[i][j] = new N6LVector(k);
                this.im[i][j] = new N6LVector(k);
            }
        }
        for(i = 0; i <= this.n; i++) {
            this.b[i] = 0.0;
            this.c[i] = 0.0;
            this.d[i] = new N6LVector(k);
        }

        //---力の設定-------	
        this.swa = true; //２物体間の相互作用
        //強さ
        //aa(0, 0) = -50000
        //aa[1][0]=-50000; aa[1][1]=0.;
        //aa[2][0]=100000.; aa[2][1]=0.; aa[2][2]=0.;
        //力のべき（-2は万有引力やクーロン力，1はバネの弾性力）
        //ap(0, 0) = -2
        //ap[1][0]=-2; ap[1][1]=0;
        //ap[2][0]=100000.; ap[2][1]=0.; ap[2][2]=0.;
        //バネの長さ
        //al(0, 0) = 0.0
        //al[1][0]=0.; al[1][1]=0.;
        //al[2][0]=100000.; al[2][1]=0.; al[2][2]=0.;


        //if(n > 0) { '//対称化（作用・反作用の法則）
        //    for(i = 1; i <= n; i++) {
        //        for(j = 0; j <= i - 1; j++) {
        //            aa[j][i] = aa[i][j];
        //            ap[j][i] = ap[i][j];
        //            al[j][i] = al[i][j];
        //        }
        //    }
        //}

        this.swb = false; //速さに比例する力（粘性抵抗）
        //b[0]=0.; b[1]=0.; b[2]=0.;

        this.swc = false; //速さの二乗に比例する抵抗（慣性抵抗）
        //swc = true; //速さの二乗に比例する抵抗（慣性抵抗）
        //var P = 0.0000000000028;
        //var PACD = 800000000000.0;
        //var AR = -(1.0 / 2.0) * P * PACD;

        //c[0] = 0.0;
        //c[1] = AR;
        //c[2] = 0.0;

        this.swd = false; //一定の力（重力など）
        //d[0][0]=0.; d[0][1]=9.8*mass[0];
        //d[1][0]=0.; d[1][1]=9.8*mass[1];
        //d[2][0]=0.; d[2][1]=9.8*mass[2];		

    };

    //近日点イベント 天体番号、距離、座標を通知
    onPerihelion(i, lr, pos){
        if(this.epoch){
          var datt = this.epoch.getTime(); // Get the timestamp of the base date
          var dat1t = datt + this.time; // Calculate the new timestamp
          var dat1 = new Date(dat1t); // Create a new Date object for the updated time
          console.log("\n[" + dat1.toLocaleString() + "] onPerihelion(" + i + ", " + lr + ", " + pos.Str() + "); occurred!\n");
        }
        else {
          console.log("\n[NoDateData] onPerihelion(" + i + ", " + lr + ", " + pos.Str() + "); occurred!\n");
        }
    };

    //遠日点イベント 天体番号、距離、座標を通知
    onAphelion(i, lr, pos){
        if(this.epoch){
          var datt = this.epoch.getTime(); // Get the timestamp of the base date
          var dat1t = datt + this.time; // Calculate the new timestamp
          var dat1 = new Date(dat1t); // Create a new Date object for the updated time
          console.log("\n[" + dat1.toLocaleString() + "] onAphelion(" + i + ", " + lr + ", " + pos.Str() + "); occurred!\n");
        }
        else {
          console.log("\n[NoDateData] onAphelion(" + i + ", " + lr + ", " + pos.Str() + "); occurred!\n");
        }
    };
    //ログ
    OnDispLog(i, pos){ return; }
    OnSide(i, lr, pos){ return; }
    //近日点突入イベント
    OnEnterPerihelion(i){ return; }
    //近日点脱出イベント
    OnExitPerihelion(i){ return; }
    //遠日点突入イベント
    OnEnterAphelion(i){ return; }
    //遠日点脱出イベント
    OnExitAphelion(i){ return; }

NormalizeRad(th) {
  // 1. まず -2π ～ 2π の範囲に収める
  var ret = th % (Math.PI * 2.0);
  
  // 2. 0 ～ 2π の範囲に持ち上げる（負の数対策）
  if (ret < 0) ret += Math.PI * 2.0;
  
  // 3. -π ～ π の範囲に変換する
  if (ret > Math.PI) ret -= Math.PI * 2.0;
  
  return ret;
};

}



//ハイパボリックがMathにあるならばコメントアウトしてください
/*
//ハイパボリックサイン
Math.prototype.sinh = function(x) {
    var ret = 0.0;
    var a = Math.exp(x);
    ret = (a - 1.0 / a) / 2.0;
    return ret;
};

//ハイパボリックコサイン
Math.prototype.cosh = function(x) {
    var ret = 0.0;
    var a = Math.exp(x);
    ret = (a + 1.0 / a) / 2.0;
    return ret;
};

//ハイパボリックタンジェント
Math.prototype.tanh = function(x) {
    var ret = 0.0;
    var a = 1.0 / Math.exp(x * 2.0);
    ret = (1.0 - a) / (1.0 + a);
    return ret;
};
*/

//過去の実際のシミュレートの知見
//水星摂動は１周当たり-0.1035秒だからラジアンにすると-5.01782e-7rad
//100年415周-43秒、-2.0846988287710047724366306401392e-4rad
//誤差込み100年415周-43秒+5秒、-1.8422919882162367756416735889602e-4rad
//誤差込み100年415周-43秒-5秒、-2.3271056693257727692315876913182e-4rad
//このサンプルでは４１５周-2.24626928054717e-4rad、平均-5.42577120905113e-7radあたりの数字を出します
//何とか誤差範囲内に収まった

